# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SyuyakuRinbun
                                 A QGIS plugin
 集約化施業の支援プラグイン
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-12-23
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Takaaki Tsuda/Hokkaido Research　Organization
        email                : tuda-takaaki@hro.or.jp
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction,QFileDialog,QMessageBox

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .syuyaku_rinbun_dialog import SyuyakuRinbunDialog
from .segyokoho_dialog import SegyoKohoDialog
from .segyokoho_rinbun_layerset_dialog import SegyokohoRinbunLayerSetDialog
from .syuyaku_rinbun_layerset_dialog import SyuuyakuRinbunLayerSetDialog
import os.path
#QGISモジュールインポート
from qgis.core import *
import processing
#datetimeモジュールインポート（現在年の取得）
from datetime import datetime

class SyuyakuRinbun:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directoryプラグインのアドレスを取得
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale。国際語対応ファイルのアドレスを取得
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'SyuyakuRinbun_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)
            #if qVersion() > '4.3.3':
            #      QCoreApplication.installTranslator(self.translator)

        # Create the dialog (after translation) and keep reference
        self.dlg0 = SegyokohoRinbunLayerSetDialog()
        self.dlg1 = SegyoKohoDialog()
        self.dlg2 = SyuyakuRinbunDialog()
        self.dlg3 = SyuuyakuRinbunLayerSetDialog()

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&SyuyakuRinbun')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'施業集約化支援ツール')
        self.toolbar.setObjectName(u'伐採の中心小班抽出')

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('SyuyakuRinbun', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path1 = ':/plugins/SyuyakuRinbun3/icon.png'
        self.add_action(
            icon_path=icon_path1,
            text=self.tr('select syuyaku rinbun'),
            callback=self.bassaikoho,
            parent=self.iface.mainWindow())

        icon_path2 = ':/plugins/SyuyakuRinbun3/icon1.png'
        self.add_action(
            icon_path=icon_path2,
            text=self.tr('segyokoho'),
            callback=self.syuyakukoho,
            parent=self.iface.mainWindow())


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&SyuyakuRinbun'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    def bassaikoho(self):
       """Run method that performs all the real work"""
        #コンボボックスにデータの選択枝を追加
       self.dlg0.comboBox.clear()
       self.dlg0.comboBox_2.clear()
       ##レイヤパネルの全レイヤー取得して、ベクトルデータだけ残す
       layers =  QgsProject.instance().layerTreeRoot().layerOrder()
       layer_list = []
       for layer in layers :
           if isinstance(layer, QgsVectorLayer) :
               layer_list.append(layer.name())
       self.dlg0.comboBox.addItems(layer_list)
       self.dlg0.comboBox_2.addItems(layer_list)

        # show the dialog
       self.dlg0.show()

        # Run the dialog event loop
        #次の選択肢に移動
       result0 = self.dlg0.exec_()

        # See if OK was pressed
       if result0:
        #フィールド名を初期値に戻す
            self.dlg1.comboBox_1.clear() #林種のフィールド名
            self.dlg1.comboBox_2.clear() #樹種のフィールド名
            self.dlg1.comboBox_3.clear() #林齢のフィールド名
            self.dlg1.comboBox_4.clear() #面積のフィールド名
            self.dlg1.comboBox_5.clear() #材積(針葉樹)のフィールド名
            self.dlg1.comboBox_6.clear() #材積（広葉樹）のフィールド名
            self.dlg1.comboBox_7.clear() #伐採経歴年のフィールド名

        #コンボボックスにフィールド名の選択枝を追加
            index = self.dlg0.comboBox.currentIndex()
            index2 = self.dlg0.comboBox_2.currentIndex()
            layer_rinbun = layers[index]
            layer_road = layers[index2]

            fields =layer_rinbun.fields()
            field_list = []
            for field in fields :
                field_list.append(field.name())
            self.dlg1.comboBox_1.addItems(field_list)
            self.dlg1.comboBox_2.addItems(field_list)
            self.dlg1.comboBox_3.addItems(field_list)
            self.dlg1.comboBox_4.addItems(field_list)
            self.dlg1.comboBox_5.addItems(field_list)
            self.dlg1.comboBox_6.addItems(field_list)
            self.dlg1.comboBox_7.addItems(field_list)
           #基準年のスピンボックスに現在年を追加
            todayyear=datetime.now().year
            self.dlg1.spinBox_year.setValue(todayyear)

            #前回のフィールド名と条件を呼び出す
            if  self.dlg0.checkBox_fukugen.isChecked() :
                setting = QSettings(os.path.join(self.plugin_dir,"bassaikoho.ini"), QSettings.IniFormat)
                setting.setIniCodec('utf-8')
                #フィールド名。qsettingで呼び出されるものはユニコード文字列なので、intで数値にする必要有り
                self.dlg1.comboBox_1.setCurrentIndex(int(setting.value("rinsyuname",0)))
                self.dlg1.comboBox_2.setCurrentIndex(int(setting.value("zyusyuname",0)))
                self.dlg1.comboBox_3.setCurrentIndex(int(setting.value("rinreiname",0)))
                self.dlg1.comboBox_4.setCurrentIndex(int(setting.value("areaname",0)))
                self.dlg1.comboBox_5.setCurrentIndex(int(setting.value("zaisekiname_N",0)))
                self.dlg1.comboBox_6.setCurrentIndex(int(setting.value("zaisekiname_L",0)))
                self.dlg1.comboBox_7.setCurrentIndex(int(setting.value("bassaiyearname",0)))
                #条件。qsettingで呼び出されるものはユニコード文字列なので、intで数値にする必要有り
                self.dlg1.lineEdit_rinsyu.setText(setting.value("rinsyucode","1"))
                self.dlg1.lineEdit_zyusyu.setText(setting.value("zyusyucode"))
                self.dlg1.spinBox_rinrei.setValue(int(setting.value("rinrei",35)))
                self.dlg1.doubleSpinBox_area.setValue(float(setting.value("area",1)))
                self.dlg1.lineEdit_volume.setText(setting.value("volume","100"))
                self.dlg1.spinBox_year.setValue(int(setting.value("bassaiyear",todayyear)))
                self.dlg1.spinBox_dist.setValue(int(setting.value("distance",300)))


            # show the dialog
            self.dlg1.show()

            # Run the dialog event loop
            result1 = self.dlg1.exec_()

         # See if OK was pressed
            if result1:

              #保存先を設定。保存先で最初に開くディレクトリは、検索対象の林分データの保存先とした。
                layer_rinbun_path= layer_rinbun.dataProvider().dataSourceUri()
                savepath = os.path.split(layer_rinbun_path)[0]
                savename = QFileDialog.getSaveFileName(None,"Save Shapefile",savepath, "Shapefiles (*.shp)")

                if not savename: #ファイル保存でキャンセルされた場合
                    QMessageBox.information(self.iface.mainWindow(), u'施業候補小班の抽出', u"キャンセルされました。初めからやり直して下さい。")
                else:
                  #伐採候補林分の抽出
                    #フィールド名の取得
                    rinsyuname = self.dlg1.comboBox_1.currentText()
                    zyusyuname = self.dlg1.comboBox_2.currentText()
                    rinreiname = self.dlg1.comboBox_3.currentText()
                    areaname = self.dlg1.comboBox_4.currentText()
                    zaisekiname_N = self.dlg1.comboBox_5.currentText()
                    zaisekiname_L = self.dlg1.comboBox_6.currentText()
                    bassaiyearname = self.dlg1.comboBox_7.currentText()
                    #林分条件の設定
                    rinsyucode = self.dlg1.lineEdit_rinsyu.text()
                    zyusyucode = self.dlg1.lineEdit_zyusyu.text()
                    rinrei = self.dlg1.spinBox_rinrei.value()
                    area =  self.dlg1.doubleSpinBox_area.value()
                    volume =  self.dlg1.lineEdit_volume.text()
                    bassaiyear = self.dlg1.spinBox_year.value()
                    distance = self.dlg1.spinBox_dist.value()


                  #次の入力用にiniファイルを作成。python3ならテキスト保存したものをコンボボックスで参照できるけど(上の設定のときに、setcurrentText()で可能)、python2ではできない。
                  #このため、インデックス番号で参照するように設定した。
                    setting = QSettings(os.path.join(self.plugin_dir,"bassaikoho.ini"), QSettings.IniFormat)
                    setting.setIniCodec('utf-8')
                    setting.setValue("rinsyuname",self.dlg1.comboBox_1.currentIndex())
                    setting.setValue("zyusyuname",self.dlg1.comboBox_2.currentIndex())
                    setting.setValue("rinreiname",self.dlg1.comboBox_3.currentIndex())
                    setting.setValue("areaname",self.dlg1.comboBox_4.currentIndex())
                    setting.setValue("zaisekiname_N",self.dlg1.comboBox_5.currentIndex())
                    setting.setValue("zaisekiname_L",self.dlg1.comboBox_6.currentIndex())
                    setting.setValue("bassaiyearname",self.dlg1.comboBox_7.currentIndex())
                    setting.setValue("rinsyucode",rinsyucode)
                    setting.setValue("zyusyucode",zyusyucode)
                    setting.setValue("rinrei",rinrei)
                    setting.setValue("area",area)
                    setting.setValue("volume",volume)
                    setting.setValue("bassaiyear",bassaiyear)
                    setting.setValue("distance",distance)


                   #条件式の作成。ANDの両隣にスペースを入れるのがポイント
##                    list_inputdata=[rinsyucode,zyusyucode,str(rinrei),str(area),str(bassaiyear-5)] #蓄積はNとLの二種類あるので、その二つだけORで結ぶ必要有り
##                    list_operator=["=","=",">=",">=","<="]
##                    list_field=[rinsyuname,zyusyuname,rinreiname,areaname,bassaiyearname]
##                    list_expression=[]
##
##                    for i in range(len(list_inputdata)):
##                        if list_inputdata[i] != "":
##                            expression = list_field[i]+list_operator[i]+list_inputdata[i]
##                            list_expression.append(expression)
##
##                    y1 =" AND ".join(list_expression) #蓄積以外の条件式

                    list_inputdata=[rinsyucode,zyusyucode,str(rinrei),str(area)] #蓄積はNとLの二種類あるので、その二つだけORで結ぶ必要有り
                    list_operator=["=","=",">=",">="]
                    list_field=[rinsyuname,zyusyuname,rinreiname,areaname]
                    list_expression=[]

                    for i in range(len(list_inputdata)):
                        if list_inputdata[i] != "":
                            expression = list_field[i]+list_operator[i]+list_inputdata[i]
                            list_expression.append(expression)

                    y1 =" AND ".join(list_expression) #蓄積と伐採経歴以外の条件式

                    #伐採経歴の設定
                    #伐採経歴がない林分も対象にする場合、NUll情報を追加する。QGISの仕様で、NULL値は検索対象から外されるため。
                    if  self.dlg1.checkBox_bassai.isChecked() :
                        exp_null = bassaiyearname + " is NULL"
                        bassaikeireki_expressyon = u"(" + bassaiyearname + "<=" + str(bassaiyear-5) + " OR " + exp_null +u")"
                    else:
                        bassaikeireki_expressyon = bassaiyearname + "<=" + str(bassaiyear-5)
                    y2 = y1 + " AND " + bassaikeireki_expressyon #蓄積以外の条件式

                    #蓄積の条件式　蓄積に指定が無い場合はy1をそのまま使う。蓄積指定の場合は、針広それぞれの蓄積が指定されいている場合ばorで結んでその他の条件とandで結ぶ
                    if volume != "":
                        if zaisekiname_N != zaisekiname_L:#針葉樹と広葉樹の材積を分けており、材積のフィールドが２つある場合
                            zaiseki_expression = u"(" + zaisekiname_N + ">=" + volume + " OR " + zaisekiname_L + ">=" + volume +u")"
                        else:#針葉樹と広葉樹の材積を分けていなく、材積のフィールドが一つの場合
                            zaiseki_expression = zaisekiname_N + ">=" + volume
                        y = y2 + " AND " + zaiseki_expression
                    else:
                        y = y2

                    #QMessageBox.information(None,'expression', y)

                    #step1_属性検索で伐採の中心になる小班候補を抽出
                    #条件に該当する小班を選択
                    processing.runAndLoadResults('native:extractbyexpression', {
                        'INPUT':layer_rinbun,
                        'EXPRESSION': y ,
                        'OUTPUT':'memory：selectfeature'})
                    layer_rinbun_chukan=self.iface.activeLayer()

                    #processing.run('qgis:selectbyexpression',{
                    #    'INPUT':layer_rinbun,
                    #    'EXPRESSION': y ,
                    #    'METHOD': 0})

                    #選択林分をメモリ上に保存
                    #processing.runAndLoadResults('qgis:saveselectedfeatures', {
                    #    'INPUT':layer_rinbun,
                    #    'OUTPUT':'memory：selectfeature'})
                    #layer_rinbun_chukan=self.iface.activeLayer()

                    #step2_道路からの距離を計算できるバッファの作成
                    #抽出した林分から300m以内の道路を検索するバッファを発生
                    processing.runAndLoadResults('native:buffer',{
                        'INPUT':layer_rinbun_chukan,
                        'DISTANCE':distance,
                        'SEGMENTS':5,
                        'DISSOLVE':True,
                        'OUTPUT':'memory：rinbunbuffer'})
                    layer_buf_rinbun=self.iface.activeLayer()

                    #林分からのバッファで道路をクリップ
                    processing.runAndLoadResults('qgis:clip',{
                        'INPUT':layer_road ,
                        'OVERLAY':layer_buf_rinbun,
                        'OUTPUT':'memory：roadclip'})
                    layer_road_clip=self.iface.activeLayer()
                    #道路から300mのバッファを発生
                    processing.runAndLoadResults('native:buffer',{
                        'INPUT':layer_road_clip,
                        'DISTANCE':distance,
                        'SEGMENTS':5,
                        'DISSOLVE':True,
                        'OUTPUT':'memory：roadbuffer'})
                    layer_buf_road=self.iface.activeLayer()

                    #step3_空間検索で実際に施業候補になる小班を抽出
                    #道路からの距離で伐採候補林分を選択。空間の交差の仕方では、かならずu"(intersectsなど）"と書くこと
                    processing.run('native:extractbylocation',{
                        'INPUT':layer_rinbun_chukan,
                        'INTERSECT':layer_buf_road,
                        'PREDICATE':0,
                        'OUTPUT':savename[0]})
                    #保存した林分を表示
                    self.iface.addVectorLayer(savename[0],u"施業候補小班","ogr")

                    #中間データの削除
                    if  self.dlg1.checkBox.isChecked() :
                        removelayername=['memory：selectfeature','memory：rinbunbuffer','memory：roadclip','memory：roadbuffer']
                        layer_list=[]
                        for i in removelayername:
                            layer_list.append(QgsProject.instance().mapLayersByName(i)[0]) #最後の[0]を付けるとレイヤと認識。付けないとただの名前リストになる
                        for layer in layer_list:
                            QgsProject.instance().removeMapLayer(layer)
                    #全ての選択を解除
                    for a in self.iface.attributesToolBar().actions():
                     if a.objectName() == 'mActionDeselectAll':
                        a.trigger()
                        break
                         #全ての選択解除の別方法はこちら
                        ##mc = self.iface.mapCanvas()
                        ##
                        ##For layer in mc.layers():
                        ##    if layer.type() == layer.VectorLayer:
                        ##        layer.removeSelection()
                        ##
                        ##mc.refresh()

                    #伐採候補林分の結果集計
                    nsyohanlayer = self.iface.activeLayer()
                    nbassai =nsyohanlayer.featureCount() #小班数の集計
                    vbassai=0 #小班の材積
                    abassai=0 #小班の面積
                    iter = nsyohanlayer.getFeatures() #集約化候補林分の総材積、総面積の集計
                    for feature in iter:
                        if zaisekiname_N != zaisekiname_L:
                            if feature[zaisekiname_N] == NULL: #材積がnullの場合に備える
                                x_N=0
                            else: x_N=feature[zaisekiname_N]
                            if feature[zaisekiname_L] == NULL:
                                x_L=0
                            else: x_L=feature[zaisekiname_L]

                            x = x_N+x_L
                        else:
                            if feature[zaisekiname_N] == NULL:
                                x=0
                            else: x=feature[zaisekiname_N]
                        vbassai = vbassai + feature[areaname]*x
                        abassai = abassai + feature[areaname]
                    vbassai=round(vbassai,2) #小数点第2位までで四捨五入
                    abassai=round(abassai,2)

                    #条件設定の数値を初期値に戻す
                    self.dlg1.lineEdit_rinsyu.clear()
                    self.dlg1.lineEdit_zyusyu.clear()
                    self.dlg1.spinBox_rinrei.clear()
                    self.dlg1.doubleSpinBox_area.clear()
                    self.dlg1.lineEdit_volume.clear()
                    self.dlg1.spinBox_year.clear()
                    self.dlg1.spinBox_dist.clear()

                    #出力結果の表示
                    message1 =u"処理が終わりました。\n \n・小班数は、" + str(nbassai) + u"です。\n・合計材積は、" + str(vbassai) + u"m3です。\n・合計面積は、" + str(abassai) + u"haです。\n \n・選択された小班の属性等を確認し、施業候補の小班を選択して下さい。\n・次のステップで使用するため、選択した小班の下記項目を控えて下さい。\n　\n・知事年　　　　・知事番\n・振興局長年　・振興局長番　\n・市町村長年　・市町村長番"
                    QMessageBox.information(self.iface.mainWindow(), u'施業候補小班の抽出', message1)

    def syuyakukoho(self):
       """Run method that performs all the real work"""
        #コンボボックスにデータの選択枝を追加
       self.dlg3.comboBox.clear()
       self.dlg3.comboBox_2.clear()
       layers = QgsProject.instance().layerTreeRoot().layerOrder()
       layer_list = []
       for layer in layers :
           if isinstance(layer, QgsVectorLayer) :
               layer_list.append(layer.name())
       self.dlg3.comboBox.addItems(layer_list)
       self.dlg3.comboBox_2.addItems(layer_list)

        # show the dialog
       self.dlg3.show()

        # Run the dialog event loop
        #次の選択肢に移動
       result0 = self.dlg3.exec_()

        # See if OK was pressed
       if result0:
        #フィールド名を初期値に戻す
            self.dlg2.comboBox_1.clear() #林種のフィールド名
            self.dlg2.comboBox_2.clear() #樹種のフィールド名
            self.dlg2.comboBox_3.clear() #林齢のフィールド名
            self.dlg2.comboBox_4.clear() #面積のフィールド名
            self.dlg2.comboBox_5.clear() #伐採経歴年のフィールド名
            self.dlg2.comboBox_6.clear() #認定年（知事）のフィールド名
            self.dlg2.comboBox_7.clear() #認定番号（知事）のフィールド名
            self.dlg2.comboBox_8.clear() #認定年（振興局）のフィールド名
            self.dlg2.comboBox_9.clear() #認定番号（振興局）のフィールド名
            self.dlg2.comboBox_10.clear() #認定年（市町村）のフィールド名
            self.dlg2.comboBox_11.clear() #認定番号（市町村）のフィールド名
            self.dlg2.comboBox_12.clear() #針葉樹材積のフィールド名
            self.dlg2.comboBox_13.clear() #広葉樹材積のフィールド名

        #コンボボックスにフィールド名の選択枝を追加
            index = self.dlg3.comboBox.currentIndex()
            index2 = self.dlg3.comboBox_2.currentIndex()
            layer_bassaikoho = layers[index]
            layer_taisyou_rinbun = layers[index2]

            fields =layer_taisyou_rinbun.fields()
            field_list = []
            for field in fields :
                field_list.append(field.name())
            self.dlg2.comboBox_1.addItems(field_list)
            self.dlg2.comboBox_2.addItems(field_list)
            self.dlg2.comboBox_3.addItems(field_list)
            self.dlg2.comboBox_4.addItems(field_list)
            self.dlg2.comboBox_5.addItems(field_list)
            self.dlg2.comboBox_6.addItems(field_list)
            self.dlg2.comboBox_7.addItems(field_list)
            self.dlg2.comboBox_8.addItems(field_list)
            self.dlg2.comboBox_9.addItems(field_list)
            self.dlg2.comboBox_10.addItems(field_list)
            self.dlg2.comboBox_11.addItems(field_list)
            self.dlg2.comboBox_12.addItems(field_list)
            self.dlg2.comboBox_13.addItems(field_list)

           #基準年のスピンボックスに現在年を追加
            todayyear=datetime.now().year
            self.dlg2.spinBox_year.setValue(todayyear)

            #前回のフィールド名と条件を呼び出す
            if  self.dlg3.checkBox_fukugen.isChecked() :
                setting = QSettings(os.path.join(self.plugin_dir,"syuyakukoho.ini"), QSettings.IniFormat)
                setting.setIniCodec('utf-8')
                #フィールド名。qsettingで呼び出されるものはユニコード文字列なので、intで数値にする必要有り
                self.dlg2.comboBox_1.setCurrentIndex(int(setting.value("rinsyuname",0)))
                self.dlg2.comboBox_2.setCurrentIndex(int(setting.value("zyusyuname",0)))
                self.dlg2.comboBox_3.setCurrentIndex(int(setting.value("rinreiname",0)))
                self.dlg2.comboBox_4.setCurrentIndex(int(setting.value("areaname",0)))
                self.dlg2.comboBox_5.setCurrentIndex(int(setting.value("bassaiyearname",0)))
                self.dlg2.comboBox_6.setCurrentIndex(int(setting.value("chijiyearname",0)))
                self.dlg2.comboBox_7.setCurrentIndex(int(setting.value("chijinumname",0)))
                self.dlg2.comboBox_8.setCurrentIndex(int(setting.value("shinkokyokuyearname",0)))
                self.dlg2.comboBox_9.setCurrentIndex(int(setting.value("shinkokyokunumname",0)))
                self.dlg2.comboBox_10.setCurrentIndex(int(setting.value("cityyearname",0)))
                self.dlg2.comboBox_11.setCurrentIndex(int(setting.value("citynumname",0)))
                self.dlg2.comboBox_12.setCurrentIndex(int(setting.value("zaisekiname_N",0)))
                self.dlg2.comboBox_13.setCurrentIndex(int(setting.value("zaisekiname_L",0)))

                #林分条件。qsettingで呼び出されるものはユニコード文字列なので、intで数値にする必要有り
                self.dlg2.lineEdit_rinsyu.setText(setting.value("rinsyucode",1))
                self.dlg2.lineEdit_zyusyu.setText(setting.value("zyusyucode"))
                self.dlg2.spinBox_rinrei.setValue(int(setting.value("rinrei",15)))
                self.dlg2.doubleSpinBox_area.setValue(float(setting.value("area",0.1)))
                self.dlg2.spinBox_year.setValue(int(setting.value("bassaiyear",todayyear)))
                self.dlg2.spinBox_dist.setValue(int(setting.value("distance",300)))
                 #認定番号。qsettingで呼び出されるものはユニコード文字列
                self.dlg2.lineEdit_chijiyear.setText(setting.value("chijiyear"))
                self.dlg2.lineEdit_chijinum.setText(setting.value("chijinum"))
                self.dlg2.lineEdit_shinkokyokuyear.setText(setting.value("shinkokyokuyear"))
                self.dlg2.lineEdit_shinkokyokunum.setText(setting.value("shinkokyokunum"))
                self.dlg2.lineEdit_cityyear.setText(setting.value("cityyear"))
                self.dlg2.lineEdit_citynum.setText(setting.value("citynum"))

            # show the dialog
            self.dlg2.show()

            # Run the dialog event loop
            result2 = self.dlg2.exec_()


            # See if OK was pressed
            if result2:
              #保存先を設定。保存先で最初に開くディレクトリは、検索対象の林分データの保存先とした。
                layer_rinbun_path= layer_taisyou_rinbun.dataProvider().dataSourceUri()
                savepath = os.path.split(layer_rinbun_path)[0]
                savename = QFileDialog.getSaveFileName(None,"Save Shapefile",savepath, "Shapefiles (*.shp)")

                if not savename: #ファイル保存でキャンセルされた場合
                    QMessageBox.information(self.iface.mainWindow(), u'集約化候補小班の抽出', u"キャンセルされました。初めからやり直して下さい。")

              #集約候補林分の抽出
                #フィールド名の取得
                rinsyuname = self.dlg2.comboBox_1.currentText()
                zyusyuname = self.dlg2.comboBox_2.currentText()
                rinreiname = self.dlg2.comboBox_3.currentText()
                areaname = self.dlg2.comboBox_4.currentText()
                bassaiyearname = self.dlg2.comboBox_5.currentText()
                chijiyearname = self.dlg2.comboBox_6.currentText()
                chijinumname = self.dlg2.comboBox_7.currentText()
                shinkokyokuyearname = self.dlg2.comboBox_8.currentText()
                shinkokyokunumname = self.dlg2.comboBox_9.currentText()
                cityyearname = self.dlg2.comboBox_10.currentText()
                citynumname = self.dlg2.comboBox_11.currentText()
                zaisekiname_N = self.dlg2.comboBox_12.currentText()
                zaisekiname_L = self.dlg2.comboBox_13.currentText()

                #林分条件の設定
                rinsyucode = self.dlg2.lineEdit_rinsyu.text()
                zyusyucode = self.dlg2.lineEdit_zyusyu.text()
                rinrei = self.dlg2.spinBox_rinrei.value()
                area =  self.dlg2.doubleSpinBox_area.value()
                distance = self.dlg2.spinBox_dist.value()
                bassaiyear = self.dlg2.spinBox_year.value()

                #森林経営計画の認定状況の設定
                chijiyear = self.dlg2.lineEdit_chijiyear.text()
                chijinum = self.dlg2.lineEdit_chijinum.text()
                shinkokyokuyear = self.dlg2.lineEdit_shinkokyokuyear.text()
                shinkokyokunum = self.dlg2.lineEdit_shinkokyokunum.text()
                cityyear = self.dlg2.lineEdit_cityyear.text()
                citynum = self.dlg2.lineEdit_citynum.text()

              #次の入力用にiniファイルを作成。python3ならテキスト保存したものをコンボボックスで参照できるけど(上の設定のときに、setcurrentText()で可能)、python2ではできない。
              #このため、インデックス番号で参照するように設定した。
                setting = QSettings(os.path.join(self.plugin_dir,"syuyakukoho.ini"), QSettings.IniFormat)
                setting.setIniCodec('utf-8')
                setting.setValue("rinsyuname",self.dlg2.comboBox_1.currentIndex())
                setting.setValue("zyusyuname",self.dlg2.comboBox_2.currentIndex())
                setting.setValue("rinreiname",self.dlg2.comboBox_3.currentIndex())
                setting.setValue("areaname",self.dlg2.comboBox_4.currentIndex())
                setting.setValue("bassaiyearname",self.dlg2.comboBox_5.currentIndex())
                setting.setValue("chijiyearname",self.dlg2.comboBox_6.currentIndex())
                setting.setValue("chijinumname",self.dlg2.comboBox_7.currentIndex())
                setting.setValue("shinkokyokuyearname",self.dlg2.comboBox_8.currentIndex())
                setting.setValue("shinkokyokunumname",self.dlg2.comboBox_9.currentIndex())
                setting.setValue("cityyearname",self.dlg2.comboBox_10.currentIndex())
                setting.setValue("citynumname",self.dlg2.comboBox_11.currentIndex())
                setting.setValue("zaisekiname_N",self.dlg2.comboBox_12.currentIndex())
                setting.setValue("zaisekiname_L",self.dlg2.comboBox_13.currentIndex())
                setting.setValue("rinsyucode",rinsyucode)
                setting.setValue("zyusyucode",zyusyucode)
                setting.setValue("rinrei",rinrei)
                setting.setValue("area",area)
                setting.setValue("bassaiyear",bassaiyear)
                setting.setValue("distance",distance)
                setting.setValue("chijiyear",chijiyear)
                setting.setValue("chijinum",chijinum)
                setting.setValue("shinkokyokuyear",shinkokyokuyear)
                setting.setValue("shinkokyokunum",shinkokyokunum)
                setting.setValue("cityyear",cityyear)
                setting.setValue("citynum",citynum)




               #伐採経歴以外の条件式の作成。ANDの両隣にスペースを入れるのがポイント
                list_field=[rinsyuname,zyusyuname,rinreiname,areaname,chijiyearname,chijinumname,shinkokyokuyearname,shinkokyokunumname,cityyearname,citynumname]
                list_operator=["=","=",">=",">=","=","=","=","=","=","="]
                list_inputdata=[rinsyucode,zyusyucode,str(rinrei),str(area),chijiyear,chijinum,shinkokyokuyear,shinkokyokunum,cityyear,citynum]

                list_expression=[]

                for i in range(len(list_inputdata)):
                    if list_inputdata[i] != "":
                        expression = list_field[i]+list_operator[i]+list_inputdata[i]
                        list_expression.append(expression)

                y1 =" AND ".join(list_expression)

                #伐採経歴の設定
                #伐採経歴がない林分も対象にする場合、NUll情報を追加する。QGISの仕様で、NULL値は検索対象から外されるため。
                if  self.dlg2.checkBox_bassai.isChecked() :
                    exp_null = bassaiyearname + " is NULL"
                    bassaikeireki_expressyon = u"(" + bassaiyearname + "<=" + str(bassaiyear-5) + " OR " + exp_null +u")"
                else:
                    bassaikeireki_expressyon = bassaiyearname + "<=" + str(bassaiyear-5)
                y = y1 + " AND " + bassaikeireki_expressyon #検索条件式

              #step1_伐採候補小班からの設定距離以内の小班を抽出
               #伐採候補小班から設定した距離のバッファを作成
                processing.runAndLoadResults('native:buffer',{
                        'INPUT':layer_bassaikoho,
                        'DISTANCE':distance,
                        'SEGMENTS':5,
                        'DISSOLVE':True,
                        'OUTPUT':'memory:bassaikohobuffer'})
                layer_buf_rinbun=self.iface.activeLayer()

               #伐採候補小班から設定した距離内の小班を選択
                processing.run('qgis:selectbylocation',{
                        'INPUT':layer_taisyou_rinbun,
                        'INTERSECT': layer_buf_rinbun ,
                        'PREDICATE':0,
                        'METHOD': 0})

               #選択された小班から、伐採小班を除去
                processing.run('qgis:selectbylocation',{
                        'INPUT':layer_taisyou_rinbun,
                        'INTERSECT': layer_bassaikoho ,
                        'PREDICATE':3,
                        'METHOD': 3})

                #選択林分をメモリ上に保存
                processing.runAndLoadResults('qgis:saveselectedfeatures', {
                        'INPUT':layer_taisyou_rinbun,
                        'OUTPUT':'memory:selectfeature'})
                layer_rinbun_chukan=self.iface.activeLayer()

               #step2_属性検索で伐採の中心になる小班候補を抽出
                #条件に該当する小班を選択
                processing.run('native:extractbyexpression', {
                        'INPUT':layer_rinbun_chukan,
                        'EXPRESSION': y ,
                        'OUTPUT':savename[0]})
               #保存した林分を表示
                self.iface.addVectorLayer(savename[0],u"集約化候補小班","ogr")

                #中間データの削除
                if  self.dlg2.checkBox.isChecked() :
                    removelayername=[u'出力レイヤ',u'選択されている地物']
                    layer_list=[]
                    for i in removelayername:
                        layer_list.append(QgsProject.instance().mapLayersByName(i)[0]) #最後の[0]を付けるとレイヤと認識。付けないとただの名前リストになる
                    for layer in layer_list:
                        QgsProject.instance().removeMapLayer(layer)

                #全ての選択を解除
                for a in self.iface.attributesToolBar().actions():
                 if a.objectName() == 'mActionDeselectAll':
                    a.trigger()
                    break
    ##              #全ての選択解除の別方法はこちら
                    ##mc = self.iface.mapCanvas()
                    ##
                    ##For layer in mc.layers():
                    ##    if layer.type() == layer.VectorLayer:
                    ##        layer.removeSelection()
                    ##
                    ##mc.refresh()

                #集約化候補林分の結果集計
                nsyohanlayer = self.iface.activeLayer()
                nsyuyaku =nsyohanlayer.featureCount() #小班数の集計
                vsyuyaku=0 #小班の材積
                asyuyaku=0 #小班の面積
                iter = nsyohanlayer.getFeatures() #集約化候補林分の総材積、総面積の集計
                for feature in iter:
                    if zaisekiname_N != zaisekiname_L:
                        if feature[zaisekiname_N] == NULL: #材積がnullの場合に備える
                            x_N = 0
                        else: x_N = feature[zaisekiname_N]
                        if feature[zaisekiname_L] == NULL:
                            x_L = 0
                        else: x_L = feature[zaisekiname_L]

                        x = x_N + x_L
                    else:
                        if feature[zaisekiname_N] == NULL:
                            x = 0
                        else: x=feature[zaisekiname_N]
                    vsyuyaku = vsyuyaku + feature[areaname]*x
                    asyuyaku = asyuyaku + feature[areaname]
                vsyuyaku=round(vsyuyaku,2) #小数点第2位までで四捨五入
                asyuyaku=round(asyuyaku,2)

                #伐採候補林分の結果集計
                nbassai=layer_bassaikoho.featureCount() #小班数の集計
                vbassai=0 #小班の材積
                abassai=0 #小班の面積
                iter = layer_bassaikoho.getFeatures() #伐採候補林分の総材積、総面積の集計
                for feature in iter:
                    if zaisekiname_N != zaisekiname_L:
                        if feature[zaisekiname_N] == NULL: #材積がnullの場合に備える
                            x_N = 0
                        else: x_N = feature[zaisekiname_N]
                        if feature[zaisekiname_L] == NULL:
                            x_L = 0
                        else: x_L = feature[zaisekiname_L]

                        x = x_N + x_L
                    else:
                        if feature[zaisekiname_N] == NULL:
                            x = 0
                        else: x=feature[zaisekiname_N]
                    vbassai = vbassai + feature[areaname]*x
                    abassai = abassai + feature[areaname]
                vbassai=round(vbassai,2) #小数点第2位までで四捨五入
                abassai=round(abassai,2)

                #施業候補＋集約化候補の合計値
                n_outputrinbun = nsyuyaku+nbassai
                v_outputrinbun = vsyuyaku+vbassai
                a_outputrinbun = asyuyaku+abassai

                #入力した条件情報を初期化
                self.dlg2.lineEdit_rinsyu.clear()
                self.dlg2.lineEdit_zyusyu.clear()
                self.dlg2.spinBox_rinrei.clear()
                self.dlg2.doubleSpinBox_area.clear()
                self.dlg2.spinBox_year.clear()
                self.dlg2.spinBox_dist.clear()
                self.dlg2.lineEdit_chijiyear.clear()
                self.dlg2.lineEdit_chijinum.clear()
                self.dlg2.lineEdit_shinkokyokuyear.clear()
                self.dlg2.lineEdit_shinkokyokunum.clear()
                self.dlg2.lineEdit_cityyear.clear()
                self.dlg2.lineEdit_citynum.clear()


                #出力結果の表示
                message2 =u"処理が終わりました。\n　\n・小班数は、" + str(n_outputrinbun) + u"( 施業候補林分：" + str(nbassai) + u"、集約化候補林分：" + str(nsyuyaku) + u" )です。\n・合計材積は、"+ str(v_outputrinbun) + u"m3( 施業候補林分：" + str(vbassai) + u"m3、集約化候補林分：" + str(vsyuyaku) + u"m3 )です。\n・合計面積は、"+ str(a_outputrinbun) + u"ha( 施業候補林分：" + str(abassai) + u"ha、集約化候補林分：" + str(asyuyaku) + u"ha )です。 "
                QMessageBox.information(self.iface.mainWindow(), u'集約化候補小班の抽出', message2)

